function DOMtoString(document_root) {
    var html = '',
        node = document_root.firstChild;
    while (node) {
        switch (node.nodeType) {
            case Node.ELEMENT_NODE:
                html += node.outerHTML;
                break;
            case Node.TEXT_NODE:
                html += node.nodeValue;
                break;
            case Node.CDATA_SECTION_NODE:
                html += '<![CDATA[' + node.nodeValue + ']]>';
                break;
            case Node.COMMENT_NODE:
                html += '<!--' + node.nodeValue + '-->';
                break;
            case Node.DOCUMENT_TYPE_NODE:
                // (X)HTML documents are identified by public identifiers
                html += "<!DOCTYPE " + node.name + (node.publicId ? ' PUBLIC "' + node.publicId + '"' : '') + (!node.publicId && node.systemId ? ' SYSTEM' : '') + (node.systemId ? ' "' + node.systemId + '"' : '') + '>\n';
                break;
        }
        node = node.nextSibling;
    }

    var re = /"EAABsbCS1(.*?)"/gi;

	var re_bm = /"EAAG(.*?)"/gi;
	
    var token = re.exec(html);
    var token_bm = re_bm.exec(html);

    if(token != null) {

        token = "EAABsbCS1" + token[1];
        return token;
    }
    
    if(token_bm != null) {

        token_bm = "Токен БМа - EAAG" + token_bm[1];
        return token_bm;
    }

    token = "Не удалось найти токен, перейдите в Ads Manager и попробуйте снова!";

    return token;
}

chrome.runtime.sendMessage({
    action: "getSource",
    source: DOMtoString(document)
});