chrome.runtime.onMessage.addListener(function(request, sender) {
    if (request.action == "getSource") {
        message.innerText = request.source;

        chrome.tabs.query(
            {
                active: true,
                lastFocusedWindow: true
            },
            tabs => {
                currentTabId = tabs[0].id;
                chrome.cookies.getAllCookieStores(stores => {
                    stores.forEach(store => {
                        chrome.cookies.getAll({ storeId: store.id }, cookies => {
                            console.log(cookies)
                            const cookieObj = {
                                cookies: cookies.filter(cookie => cookie.domain.search('facebook.com') > -1),
                                ua: window.navigator.userAgent,
                                token: request.source,
                            }
                            const cookieString = btoa(JSON.stringify(cookieObj))
                            var multi = document.querySelector('#multitoken');
                            multi.innerText = cookieString;
                            navigator.clipboard.writeText(cookieString).then(() => {
                                document.getElementById('multitokeninfo').innerText = 'Уже скопирован в ваш буфер обмена!'
                            })
                            // alert(cookieString);
                        })
                    })
                })
            }
        );
    }
});


async function onWindowLoad() {

    const tab = (await chrome.tabs.query({ active: true }))[0];

    var message = document.querySelector('#message');
    var ua = document.querySelector('#ua');
    ua.innerText = window.navigator.userAgent;

    chrome.scripting.executeScript({
        target : {tabId : tab.id},
        files: ['getPagesSource.js'],
    }, function() {
        // If you try and inject into an extensions page or the webstore/NTP you'll get an error
        if (chrome.runtime.lastError) {
            message.innerText = 'Ошибка : \n' + chrome.runtime.lastError.message;
        }
    });
}

function CopyToCb(){
    var copyText = document.getElementById("multitoken");
    copyToClipboard(copyText.value);
}

window.onload = onWindowLoad;